package easik.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;
import easik.ui.datatype.DatatypesUI;


/** 
 * Menu action for quitting the application.
 * 
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 2006-06-27 Kevin Green
 */

public class EditDataTypesAction extends AbstractAction {	
	/**
	 *	Set up the quit menu option.
	 */
	public EditDataTypesAction() {
		super("Edit Data Types");
		putValue( AbstractAction.MNEMONIC_KEY,  new Integer(KeyEvent.VK_Q));
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Edit the values of the current sketch data types");		
	}
	
	/**
	 * Brings up a dialog to change the document data types.
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		new DatatypesUI(Easik.getInstance().getFrame().getSketch().getDataTypeController());
		//Assume that this means they are making changes and set sketch to dirty
		Easik.getInstance().getFrame().getSketch().setDirty(true);
	}
}